<?php
/**
 * Plugin Name: LegallyMail Certified Email
 * Plugin URI:  https://legallymail.com
 * Description: Send and track certified emails directly from WordPress. Use SMS, Email, and WhatsApp certification.
 * Version:     1.2.0
 * Author:      LegallyMail
 * License:     GPL-2.0+
 * Text Domain: legallymail-certified-email
 * Requires at least: 6.0
 * Requires PHP:      7.0
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'LEGALLYMAIL_VERSION', '1.2.0' );
define( 'LEGALLYMAIL_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'LEGALLYMAIL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Include dependent files
require_once LEGALLYMAIL_PLUGIN_DIR . 'includes/class-legallymail-api.php';
require_once LEGALLYMAIL_PLUGIN_DIR . 'admin/class-legallymail-admin.php';

// Activation Hook
function activate_legallymail_plugin() {
    LegallyMail_Admin::create_db_tables();
}
register_activation_hook( __FILE__, 'activate_legallymail_plugin' );

// Initialize the plugin
function run_legallymail_plugin() {
	$plugin_admin = new LegallyMail_Admin();
	$plugin_admin->run();
}
run_legallymail_plugin();
