# LegallyMail Certified Email for Salesforce

Send and track certified emails directly from your Salesforce records (Contacts, Leads, Accounts) with full legal validity.

## Features
- **Native Integration**: Send certified emails via Lightning Web Components.
- **Auto-detection**: Automatically fetches recipient email addresses from Contact or Lead records.
- **Templates**: Create, save, and reuse email templates for faster sending.
- **Bulk Sending**: Send certified emails to multiple contacts at once from list views.
- **Email History**: Track all sent emails with status and tracking IDs in a dedicated log.
- **Attachments**: Support for up to 4 attachments (PDF, DOC, DOCX, JPG, PNG).
- **Legal Proof**: Every email generates a certificate with a cryptographic hash and timestamp.

---

## Installation Guide

### 1. Prerequisites
- **Salesforce CLI**: [Download and install](https://developer.salesforce.com/tools/sfdxcli) if you haven't already.
- **Developer Hub**: A Salesforce Org (Free Developer Edition recommended). Sign up at [developer.salesforce.com/signup](https://developer.salesforce.com/signup).
- **LegallyMail Account**: You need an API Token from [legallymail.com](https://legallymail.com).

### 2. Deploy to your Org
1. Open your terminal in the `salesforce_app` directory.
2. Log in to your Salesforce Org:
   ```bash
   sf org login web --set-default
   ```
3. Deploy the source code:
   ```bash
   sf project deploy start
   ```

### 3. Post-Deployment Configuration
After a successful deployment, follow these steps inside your Salesforce Org:

#### A. Configure Remote Site Settings
Salesforce requires permission to connect to external APIs.
1. Go to **Setup** (Configuración) -> **Remote Site Settings**.
2. Click **New Remote Site**.
3. **Name**: `LegallyMailAPI`
4. **URL**: `https://legallymail.com`
5. Click **Save**.

#### B. Configure API Token
Open the `LegallyMailService.cls` Apex class and update the `getApiToken()` method with your LegallyMail API Token:
1. In Setup, search for **Apex Classes**.
2. Find and click **Edit** next to `LegallyMailService`.
3. Replace `'YOUR_API_TOKEN'` with your actual token.
4. Click **Save**.

**Recommended**: For production use, configure a **Named Credential** instead of hardcoding the token.

#### C. Add Component to Record Pages
1. Navigate to any **Contact** or **Lead** record.
2. Click the gear icon (top right) -> **Edit Page**.
3. In the left panel, search for the custom component: **LegallyMail Certified Email**.
4. Drag and drop it onto the page layout (e.g., in the right sidebar).
5. Click **Save** and then **Activate** (Assign as Org Default).

#### D. Enable Bulk Sending (Optional but Recommended)
To send certified emails to multiple contacts at once:
1. Go to **Setup** -> **Object Manager** -> **Contact** (or **Lead**).
2. Click **Buttons, Links, and Actions**.
3. Click **New Action**.
   - **Action Type**: Lightning Web Component
   - **Lightning Web Component**: `c:legallyMailBulkSend`
   - **Label**: `Send Certified Email (Bulk)`
4. Click **Save**.
5. Go to **List View Button Layout** for Contact.
6. Click the dropdown arrow next to any list view -> **Edit**.
7. Add your new action `Send Certified Email (Bulk)` to the available buttons.
8. Click **Save**.

---

## Usage

### Individual Email Sending
1. Open a **Contact** or **Lead**.
2. Find the **LegallyMail** component on the page.
3. The recipient's email will be pre-filled automatically.
4. (Optional) Select a saved template from the dropdown.
5. Enter the **Subject** and **Message**.
6. (Optional) Upload up to 4 attachments.
7. Click **Send Certified Email**.
8. You will receive a success message with the **Tracking ID**.

### Bulk Email Sending
1. Go to the **Contacts** or **Leads** list view.
2. Select multiple records using the checkboxes.
3. Click **Send Certified Email (Bulk)** from the actions menu.
4. The wizard will show how many recipients were found.
5. (Optional) Select a template.
6. Enter **Subject** and **Message**.
7. Click **Send Bulk**.
8. You'll receive a summary of successful sends and any errors.

### Managing Templates
1. Click the App Launcher (9 dots) and search for **LegallyMail Templates**.
2. Click **New** to create a template.
3. Enter a **Name**, **Subject**, and **Body** (supports rich text/HTML).
4. Click **Save**.
5. Your templates will now appear in the dropdown when sending emails.

### Viewing Email History
1. Click the App Launcher and search for **LegallyMail Logs**.
2. You'll see all sent certified emails with:
   - Recipient email
   - Subject
   - Tracking ID
   - Status
3. Click any record to view full details.

---

## Requirements
- Salesforce API Version 58.0 or higher.
- LegallyMail API Token.
- Internet connectivity for API calls.

## Troubleshooting

**Problem**: "Remote host closed connection during handshake"
- **Solution**: Verify Remote Site Settings are configured correctly.

**Problem**: "Unauthorized endpoint"
- **Solution**: Check that your API token is correct in `LegallyMailService.cls`.

**Problem**: Bulk action doesn't appear
- **Solution**: Make sure you've added the action to the List View Button Layout.

---

## License
License: GPLv2 or later.
Developed by LegallyMail.

## Support
For issues or questions, contact support@legallymail.com or visit [legallymail.com](https://legallymail.com).
