from odoo import models, _
from odoo.exceptions import UserError

class ResPartner(models.Model):
    _inherit = 'res.partner'

    def action_open_legallymail_wizard(self):
        """Open the wizard to send certified email to this partner(s)."""
        partners_with_email = self.filtered(lambda p: p.email)
        
        if not partners_with_email:
            raise UserError(_("The selected partner(s) do not have a valid email address."))

        emails = ', '.join([p.email.strip() for p in partners_with_email])

        return {
            'name': _('Send Certified Email'),
            'type': 'ir.actions.act_window',
            'res_model': 'legallymail.send.wizard',
            'view_mode': 'form',
            'target': 'new',
            'context': {
                'default_recipient_emails': emails,
            }
        }
