# LegallyMail Certified Email for Odoo

Send and track certified emails with full legal validity directly from your Odoo dashboard.

## Description

LegallyMail Certified Email allows you to send certified communications with legal proof of delivery directly from Odoo. Every email sent through this module is tracked and certified, providing you with a downloadable PDF certificate that contains a cryptographic hash and timestamp.

## Key Features

*   **Legal Validity**: Send emails that hold up in court with proof of delivery and content.
*   **Tracking**: Monitor real-time status: Sent, Delivered, and Read directly within Odoo.
*   **Certificates**: Download official PDF certificates for every communication.
*   **Attachments**: Send attachments with your certified emails.
*   **Integrated Workflow**: Send certified emails using a simple wizard interface.
*   **Status Updates**: Check the status of your sent emails with a single click.

## Installation

1.  Download the `legallymail_odoo` module folder.
2.  Place the folder into your Odoo `addons` directory.
3.  Restart your Odoo server.
4.  Activate **Developer Mode** in Odoo.
5.  Go to **Apps** and click **Update Apps List**.
6.  Search for "LegallyMail Certified Email" and click **Install**.

## Configuration

1.  Go to **Settings** > **LegallyMail**.
2.  Enter your **LegallyMail API Token**.
    *   You can get your API Token from your [LegallyMail Dashboard](https://legallymail.com/api-tokens).
3.  Click **Save**.

## Usage

### Sending a Certified Email

1.  Navigate to **LegallyMail** > **Send New** in the main menu.
2.  Enter the recipient email address(es) (comma-separated).
3.  Enter a Subject and Message.
4.  (Optional) Attach any files you wish to include.
5.  Click **Send**.

### Tracking Emails

1.  Go to **LegallyMail** > **Certified Emails**.
2.  You will see a list of all sent certified emails with their current status (Queued, Sent, Delivered, Read, Failed).
3.  Click on any record to view details, including the API response and any error messages.
4.  Click the **Check Status** button to update the status from the LegallyMail server.
5.  If a certificate is available, click the **Download Certificate** button to view the official PDF proof.

## Requirements

*   Odoo 14.0 or later (tested on Odoo 16/17).
*   A valid [LegallyMail](https://legallymail.com) account.
*   Python `requests` library (standard in Odoo environments).

## Support

For support or questions, please contact support@legallymail.com or visit our website.
